 aR  d  w  mP9      h	 oU     nSystem-wide$DEBUG LIST
	NAME		RealToString

CGROUP  GROUP CODE
DGROUP  GROUP DATA
ASSUME  CS:CGROUP, DS:DGROUP

DATA    SEGMENT PARA PUBLIC 'DATA'
DATA    ENDS

CODE    SEGMENT BYTE PUBLIC 'CODE'

	PUBLIC	RealToString, RealToBuffer

	PUBLIC	RoundResult, ConvertIntegerPart, ConvertFractionPart
	PUBLIC	PutItIntoAString, ShiftLong, MultiplyByTen, DivideByTen

	EXTRN	IntegerToString:NEAR
	EXTRN	ConcatStrings:NEAR
	EXTRN	AppendAnyChar:NEAR
	EXTRN	NewString:NEAR
	EXTRN	FreeString:NEAR
	EXTRN	NewStringLit:NEAR

errorConst		DB 'Error'

ByteStruc STRUC
	byteArray 	DW 4 DUP (?)
ByteStruc ENDS

stringType STRUC
	strLen		DW ?
	strMax		DW ?
	strchars	DB 200 DUP (?)
stringType ENDS

resultMax		EQU 20
resultTypeLen		EQU resultMax + 4
resultType STRUC
	len		DW ?
	resultExp	DW ?
	chars		DB resultMax DUP (?)
resultType ENDS

true		   	EQU 01
false		   	EQU 00
ten 	        	EQU 10
scientific       	EQU 0FFFEH
sigBits	        	EQU 52
MaxDigits        	EQU 15
maxDecimalPlaces 	EQU 310
expAllOnes       	EQU 07FFH

$EJECT 
;------------------------------------------------------------
DivideByTen  PROC NEAR
;FUNCTION DivideByTen (VAR byteArray: ARRAY[1..8] OF BYTE): WORD;
; 
; The 64 bit unsigned number is divided by ten and returned in the same array.
; Register usage
;    Parameters    SS:SI    Pointer to number
;
;    Destroyed     BX, CX, DX, SI, DI, ES, DS
;
;    Returned      AX       Remainder
;------------------------------------------------------------
localBytes	EQU 0
paramBytes	EQU 0
param		EQU [BP]
params STRUC
;---------------------
oldBP		DW ?
returnIP	DW ?
;---------------------
params ENDS

;Prologue
;	PUSH	BP
;	MOV	BP, SP
;	SUB	SP, localBytes
;---------------------

	ADD	SI, 6		; Start at the end of the array
	MOV	DI, SI

	MOV	BX, SS		; Load the pointers for the load and store 
	MOV	ES, BX		; instructions below
	MOV	DS, BX

	MOV	BX, 10		; Denominator
	MOV	CX, 4		; Loop counter

	XOR	DX, DX		; Initialize the remainder

	STD			; Set direction to run the loop from 6 to 0

Divide:
	LODSW
	DIV	BX
	STOSW
	LOOP Divide
	
	MOV	AX, DX		; Put the remainder into AX 

;---------------------
epilogue:
;	MOV	SP,BP
;	POP	BP
	RET	paramBytes

DivideByTen  ENDP

PURGE localBytes, paramBytes, params, param, oldBP, returnIP, epilogue, divide
$EJECT
;------------------------------------------------------------
MultiplyByTen  PROC NEAR
;PROCEDURE MultiplyByTen (VAR byteArray: ARRAY[1..8] OF BYTE);
;
; The 64 bit unsigned number contained in the byte array is multiplied by ten. 
; Register usage
;	Parameters	SS:SI   Pointer to number
;
;	Destroyed	AX, BX, CX, DX
;
;	Returned	SS:SI   Pointer to number
;------------------------------------------------------------
localBytes	EQU 0
paramBytes	EQU 0
param		EQU [BP]
params STRUC
;---------------------
oldBP		DW ?
returnIP	DW ?
;---------------------
;---------------------
params ENDS

array EQU SS:[SI]

;Prologue
;	PUSH	BP
;	MOV	BP,SP
;	SUB	SP,localBytes
;---------------------

	MOV	BX, ten		; Multiplicand


StartMultiply:
	MOV	AX, array.byteArray[0]
	MUL	BX
	MOV	array.byteArray[0], AX
	MOV	CX, DX		; Save the high word

	MOV	AX, array.byteArray[2]
	MUL	BX
	ADD	AX, CX		; Add in the high word from the last mul
	MOV	array.byteArray[2], AX
	MOV	CX, 0		; Don't disturb the carry flag
	ADC	CX, DX		; Add the carry from the add to the high word 
				; from the multiply

	MOV	AX, array.byteArray[4]
	MUL	BX
	ADD	AX, CX		; Add in the overflow from the last mul
	MOV	array.byteArray[4], AX
	MOV	CX, 0		; Don't disturb the carry flag
	ADC	CX, DX		; Add the carry from the add to the high word 
				; from the multiply

	MOV	AX, array.byteArray[6]
	MUL	BX
	ADD	AX, CX
	MOV	array.byteArray[6], AX

;---------------------
epilogue:
;	MOV	SP,BP
;	POP	BP
	RET	paramBytes

MultiplyByTen  ENDP

PURGE localBytes, paramBytes, params, param, oldBP, returnIP, epilogue, array
$EJECT
;------------------------------------------------------------
ShiftLong  PROC NEAR
;PROCEDURE ShiftLong (VAR byteArray: ARRAY[1..8] OF BYTE; count: WORD);
; 
; The 64 bit unsigned numbers contained in the byte array is shifted by 
; the specified number of bits.
; The number is shifted right if the count is positive, left otherwise.
;
; Register usage
;	Parameters	SS:SI  Pointer to num
;			CX     count
;	Destroyed	AX, BX, CX, DX, DI
;	Returned	SS:SI Pointer to num
;------------------------------------------------------------
localBytes	EQU 0
paramBytes	EQU 0
param		EQU [BP]
params STRUC
;---------------------
oldBP		DW ?
returnIP	DW ?
;---------------------
params ENDS

array		EQU SS:[SI]

;Prologue
;	PUSH	BP
;	MOV	BP,SP
;	SUB	SP,localBytes
;---------------------

	JCXZ	epilogue		; Jump if count = 0

	MOV	AX, array.byteArray[0]	;Load the number into the 4 registers
	MOV	BX, array.byteArray[2]
	MOV	DX, array.byteArray[4]
	MOV	DI, array.byteArray[6]

	OR	CX, CX	;Check the sign of the count
	JNS	ShiftRight		;Jump if positive - Shift right

	NEG	CX
ShiftLeft:
	SHL	AX, 1
	RCL	BX, 1
	RCL	DX, 1
	RCL	DI, 1
	LOOP	ShiftLeft
	JMP	SHORT ShiftDone

ShiftRight:
	SHR	DI, 1
	RCR	DX, 1
	RCR	BX, 1
	RCR	AX, 1
	LOOP	ShiftRight

ShiftDone:
	MOV	array.byteArray[0], AX	;Save the shifted number
	MOV	array.byteArray[2], BX
	MOV	array.byteArray[4], DX
	MOV	array.byteArray[6], DI

;---------------------
epilogue:
;	MOV	SP,BP
;	POP	BP
	RET	paramBytes

ShiftLong ENDP

PURGE localBytes, paramBytes, params, param, oldBP, returnIP, epilogue, array, shiftLeft, shiftright, shiftdone
$EJECT
;------------------------------------------------------------
RoundResult  PROC NEAR
;PROCEDURE RoundResult(VAR result: resulttype);
; 
; This routine rounds the result string.  It is assumed that there is always an 
; extra character at the end of the string for rounding.
;
;  Parameers	SS:DI	Pointer to result
;  Destroyed	AX, BX, CX, DX, SI, DI, ES, DS
;  Returned	NONE
;------------------------------------------------------------
result		EQU SS:[DI]

localBytes	EQU 0
paramBytes	EQU 0
param		EQU [BP]
params STRUC
;---------------------
oldBP		DW ?
returnIP	DW ?
;---------------------
;---------------------
params ENDS

;Prologue
;	PUSH	BP
;	MOV	BP,SP
;	SUB	SP,localBytes
;---------------------

	MOV	AX, DI			; Save DI for later

	MOV	CX, result.len		; Keep the length in a reg
	JCXZ	Epilogue		; IF result.len = 0 THEN RETURN

	MOV	BX, CX			; Move it into BX for indexing
	CMP	result.chars[BX], '4'	; IF result.chars(result.len) > '4' THEN 
	JBE	decTheLen		;   round

propagateIt:
	DEC	BX			; BX is the current pointer into the result
	JZ	propagateOne		; If current = 0 THEN insert a high order 1

	CMP	result.chars[BX], '9'	; IF result.chars(current) = '9' THEN carry 1
	JNZ	propagateNothing

	MOV	result.chars[BX], '0'	; result.chars(current) = '0'
	JMP	SHORT propagateIt	; Carry a 1 to the next higher digit

propagateOne:				; insert a '1' at the start of the result
	MOV	CX, result.len
	DEC	CX			; Don't move the last char - it's only for
					; rounding
	
	MOV	BX, ES
	MOV	DS, BX
	LEA	DI, result.chars	; ES:DI is destination
	ADD	DI, CX
	MOV	SI, DI			; DS:SI is the source
	INC	DI			; Destination is one past source

	STD				; Move reverse bytes
	REP	MOVSB

	MOV	DI, AX
	MOV	result.chars[1], '1'	; Put in the propagated '1'
	INC	result.resultExp	; Since it's moved over 1 digit, inc the exp

	JMP	SHORT epilogue		; Exit since the length is already set right

propagateNothing:
	INC	result.chars[BX]	; result.chars(current) = 
					; result.chars(current) + 1

decTheLen:
	DEC	result.len

;---------------------
epilogue:
;	MOV	SP,BP
;	POP	BP
	RET	paramBytes

RoundResult ENDP

PURGE localBytes, paramBytes, params, param, oldBP, returnIP, epilogue, result, propagateIt, decTheLen, propagateNothing, propagateOne
$EJECT
;------------------------------------------------------------
ConvertIntegerPart  PROC NEAR
;PROCEDURE ConvertIntegerPart (exp: Integer; VAR num: ARRAY[1..8] of Byte; 
;                              VAR result: resulttype);
; 
; This routine extracts the integer part from the 64 bit number passed in.
; It is assumed that the exp is > 0
;
; Register usage
;	Parameters	SS  segment for pointers
;	Destroyed	AX, BX, CX, DX, SI, DI, ES, DS
;	Returned	none
;------------------------------------------------------------
result		EQU SS:[DI]

localBytes	EQU 27
local		EQU [BP-localBytes]
locals STRUC
;---------------------
digits		DB 17 DUP(?)
decimalExp	DW ?
tNum		DB 8 DUP(?)
;---------------------
locals ENDS

paramBytes	EQU 6
param		EQU [BP]
params STRUC
;---------------------
oldBP		DW ?
returnIP	DW ?
;---------------------
resultPtr	DW ?
pNum		DW ?
exp		DW ?
;---------------------
params ENDS

;Prologue
	PUSH	BP
	MOV	BP,SP
	SUB	SP,localBytes
;---------------------

	; Put the number into a temporary variable
	MOV	SI, param.pNum
	MOV	AX, SS			; DS:SI is the source (pNum)
	MOV	ES, AX
	MOV	AX, DS
	LEA	DI, local.tnum		; ES:DI is the dest (tNum)
	MOV	CX, 4			; Number is 8 bytes long
	CLD
	REP	MOVSW

	MOV	local.decimalExp, 0	; Init the zero count

	LEA	SI, local.tNum
	CMP	param.exp, sigBits	; Are there zeros to the left of the decimal?
	JLE	convertInteger

	; Count the zeros
	MOV	CX, -4			; Make room for the division

CountZeros:
	CALL	ShiftLong

	PUSH	SI
	CALL	DivideByTen		; Returns the remainder in AX
	POP	SI
	INC	local.decimalExp	; decimalExp = decimalExp + 1

	MOV	CX, 4			; Find the MSB and adjust the exponent
	TEST	local.tNum[6], 20H	; expChage=the number of bits that the divide
	JZ	fourBits		; shifted the number right - either 3 or 4
	DEC	CX
fourBits:

	SUB	param.exp, CX		; exp = exp - expChange

	NEG	CX			; Shift it back by (- expChange)

	CMP	param.exp, sigBits	; Are there zeros to the left of the decimal?
	JG	CountZeros

	ADD	CX, 4			; Shift 4 - expchange
	CALL	ShiftLong		; Move the number back into the proper pos

convertInteger:
	; Adjust the number so that only the bits to the left of the decimal point
	; are left
	MOV	CX, sigBits
	SUB	CX, param.exp
	CALL	ShiftLong		; CALL ShiftLong(@tNum, sigBits - exp)

	MOV	AX,param.exp
	INC	AX
	MOV	CX, 3
	MUL	CX
	MOV	CX, 10
	XOR	DX, DX
	DIV	CX			;significantDigits = ((exp + 1) * 3) / 10

	PUSH	AX			;save significantDigits for later

	; Move the numbers into a temporary variable since they are read out
	; backwards and I don't know exactly how many of them there are.  Leave
	; room at digit 0 just in case there is an extra (we have 15.5 digits of
	; precision).
	MOV	DI, AX
	INC	DI			; Convert 1 extra just to check
convertDigits:				; DO i = significantDigits TO 0 BY -1
	PUSH	DI			; Save i
	LEA	SI, local.tNum
	CALL	DivideByTen		; digit(i) = DivideByTen(@tNum) + '0'
	ADD	AL, '0'
	POP	DI			; Restore i
	DEC	DI
	MOV	local.digits[DI], AL
	JNZ	SHORT convertDigits

	POP	CX			; significantDigits
	; Check to see if there is an extra digit
	INC	DI			; start = 1 (assume no extra digit)
	CMP	local.digits, '0'	; IF digits(0) <> '0' THEN
	JE	notAnExtraDigit
	INC	CX			; significantDigits = significantDigits + 1
	DEC	DI			; start = 0
notAnExtraDigit:

	PUSH	CX			; Save significantDigits again
	; Move the just converted characters into result.chars
	LEA	SI, local.digits[DI]
	MOV	DI, param.resultPtr
	LEA	DI, result.chars[1]
	MOV	BX, SS
	MOV	DS, BX
	MOV	ES, BX
	CLD				; CALL MovB(@local.digits(start), 
					; @result.chars(1), significantDigits)
	REP	MOVSB

	MOV	DI, param.resultPtr
	POP	AX			; significantDigits
	MOV	result.len, AX		; result.len = significantDigits

	ADD	AX, local.decimalExp
	DEC	AX
	MOV	result.resultExp, AX	; result.exp=decimalExp+significantDigits-1

;---------------------
epilogue:
	MOV	SP,BP
	POP	BP
	RET	paramBytes

ConvertIntegerPart ENDP

PURGE localBytes, local, locals, paramBytes, params, param, oldBP, returnIP, epilogue, result, digits, decimalExp, tNum, exp, pNum, resultPtr, countZeros, fourbits, convertinteger, convertdigits, notanextradigit

$EJECT
;------------------------------------------------------------
ConvertFractionPart  PROC NEAR
;PROCEDURE ConvertFractionPart (exp: Integer; VAR num: ARRAY[1..8] of Byte; 
;                               VAR result: resulttype; decimalPlaces: Integer);
; 
; This routine extracts the fraction part from the 64 bit number passed in.
; DecimalPlaces is the number of digits to appear to the right of the decimal
; point.
;
; Register usage
;	Parameters	SS  Segment for pointer variables
;	Destroyed	AX, BX, CX, DX, SI, DI, ES, DS
;	Returned	none
;------------------------------------------------------------

localBytes	EQU 2
local		EQU [BP-localBytes]
locals STRUC
;---------------------
decimalExp	DW ?
;---------------------
locals ENDS

paramBytes	EQU 8
param		EQU [BP]
params STRUC
;---------------------
oldBP		DW ?
returnIP	DW ?
;---------------------
decimalPlaces	DW ?
resultPtr	DW ?
pNum		DW ?
exp		DW ?
;---------------------
params ENDS

result		EQU SS:[DI]
num		EQU SS:[SI]

;Prologue
	PUSH	BP
	MOV	BP,SP
	SUB	SP,localBytes
;---------------------

	MOV	local.decimalExp, 0
	
	MOV	SI, param.pnum		; Get the offset part

	; If the binary exponent is >= 0, shift the number to the right to get rid
	; of the integer part.
	; Only set the decimal exponent if the exp is < 0 (otherwise it was already 
	; set
	MOV	CX, param.exp
	OR	CX, CX
	STC				; Carry = Set the decimal exp
	JL	continue
	NEG	CX
	CALL	ShiftLong
	MOV	BYTE PTR num[7], 0	; num(7) = 0
	AND	BYTE PTR num[6], 0FH	; num(6) = num(6) AND 0FH

	CLC				; Don't set the exponent
continue:

	; Save the carry flag (whether or not to set the decimal exponent)
	PUSHF

	; Add 1 to the decimal places converted to allow for later rounding
	CMP	param.decimalPlaces, maxDecimalPlaces
	JNB	whileTop
	INC	param.decimalPlaces

whileTop:

	; Convert digits until either enough have been converted or the max
	; precision has been reached
	MOV	DI, param.resultPtr	; DO WHILE (result.len < maxDigitsToConvert)
	CMP	WORD PTR result.len, maxDigits
	JAE	endWhile		;          AND (decimalPlaces > 0)

	; SS:SI already contains the right thing
	CALL	MultiplyByTen		; Does not destroy SS:SI

	CMP	param.exp, 0		; IF exp >= 0 THEN Append a digit; else
	JGE	continue2

	MOV	AX, 4			; Figure out how many bits the number was
	TEST	BYTE PTR num[7], 01	; shifted left by the multiply
	JNZ	fourBits
	DEC	AX			; It was only 3
fourBits:

	MOV	BX, AX			; BX = numBits
	MOV	CX, param.exp
	ADD	AX, CX			; newExp = exp + numBits

	JL	zeroDigit		; IF newExp >= 0 THEN

	XOR	AX, AX			; There is a digit to append
	NEG	CX			; CX = -exp ( amount to shift)
	JMP	SHORT continue3

zeroDigit:				; Add a zero digit
	INC	local.decimalExp	; decimalExp = decimalExp + 1
	MOV	CX, BX			; CX = amount to shift = numBits

continue3:
	MOV	param.exp, AX		; exp = newExp OR 0
					; CX is amount to shift
	CALL	ShiftLong

	CMP	param.exp, 0		; IF exp >= 0 THEN
	JL	whileBottom

continue2:				; exp >= 0
	; Append a digit
	MOV	DI, param.resultPtr
	INC	result.len		; result.len = result.len + 1
	
	MOV	BX, result.len
	MOV	AL, num[6]
	MOV	CL, 4
	SHR	AL, CL
	ADD	AL, '0'			; result.chars(result.len) = 
	MOV	result.chars[BX], AL	;           SHR(bytes(6),4) + '0'

	; Get rid of the digit just appended
	AND	BYTE PTR num[6], 0FH	; num(6) = num(6) AND 0FH
		
whileBottom:				; Continue the loop
	DEC	param.decimalPlaces
	JNZ	whileTop

endWhile:

	POPF			  	; POP the carry flag set above
	JNC	epilogue		; IF setExp THEN
	MOV	DI, param.resultPtr
	MOV	AX, local.decimalExp
	NOT	AX
	MOV	result.resultExp, AX	; result.exp = -(decimalExp + 1)
	
;---------------------
epilogue:
	MOV	SP,BP
	POP	BP
	RET	paramBytes

ConvertFractionPart ENDP

PURGE localBytes, local, paramBytes, params, param, oldBP, returnIP, epilogue, result, locals, decimalPlaces, resultPtr, continue, num
$EJECT
;------------------------------------------------------------
PutItIntoAString  PROC NEAR
;PROCEDURE PutItIntoAString (VAR pStr: StringPtr; VAR result: resulttype;
;                            decimalPlaces: Integer; negNum: Boolean);
; 
; This routine takes the result and puts into the proper format in a string.
; If there is room in the string provided it is used, otherwise a new string is
; allocated.
; 
; Register usage
;	Parameters	SS  Segment part of pointer parameters
; 	Destroyed	AX, BX, CX, DX, SI, DI, ES, DS
;	Returned	none
;------------------------------------------------------------

localBytes	EQU 10
local		EQU [BP-localBytes]
locals STRUC
;---------------------
digitsToTheLeft  DW ?
zerosToTheLeft   DW ?
zerosToTheRight  DW ?
digitsToTheRight DW ?
trailingZeros    DW ?
;---------------------
locals ENDS

paramBytes	EQU 10
param		EQU [BP]
params STRUC
;---------------------
oldBP		DW ?
returnIP	DW ?
;---------------------
negNum		DW ?
decimalPlaces	DW ?
resultPtr	DW ?
ppStr		DD ?
;---------------------
params ENDS

result		EQU SS:[DI]
string		EQU ES:[SI]

;Prologue
	PUSH	BP
	MOV	BP,SP
	SUB	SP,localBytes
;---------------------

	; remove trailing zeros - they can be added back later if necessary
	MOV	DI, param.resultPtr
	MOV	BX, result.len
	INC	BX	   		; DO WHILE (result.len > 0) AND
removeZeros:				;          (result.chars(result.len) = '0')
	DEC	BX			; result.len = result.len - 1
	JZ	noMoreZeros
	CMP	result.chars[BX], '0'
	JE	removeZeros

noMoreZeros:
	MOV	result.len, BX


	; Check for -0
	MOV	AX, param.negNum
	RCR	AL, 1
	JNC	notMinusZero		; IF negNum AND
	CMP	result.len, 0
	JNZ	notMinusZero		;    (result.len = 0) THEN
	MOV	param.negNum, false	;   negNum = false
notMinusZero:

	; The number is made up of 
	;   <digitsToTheLeft><zerosToTheLeft>.
	;   <zerosToTheright><digitsToTheRight><trailingZeros>
	; Any of the counts may be 0

	; Set the counts
	MOV	AX, result.len
	MOV	BX, result.resultExp
	; CX = digitsToTheRight
	; DX = digitsToTheLeft
	; SI = zerosToTheLeft
	; DI = zerosTotheRight
	XOR	SI, SI			; zerosTotheRight = 0
	MOV	DI, SI			; zerosToTheLeft

	CMP	param.decimalPlaces, scientific
	JNZ	notScientificCount	; IF decimalPlaces = scientific THEN
	; It's scientific		;   DO;
	OR	AX, AX			;   IF result.len = 0 THEN
	JNZ	continue		;     DO;
	INC	SI			;     zerosToTheLeft = 1
	MOV	CX, DI			;     digitsToTheRight = 0
	JMP	SHORT doneCounting	;     END;
					;   ELSE  
continue:				;     result.len > 0 AND it's scientific
	MOV	CX, AX			;     digitsToTheRight = result.len - 1
	DEC	CX
	JMP	SHORT doneCounting	;   END;

notScientificCount:			; ELSE
	OR	BX, BX			;   IF result.exp < 0 THEN
	JGE	expGE0			;     DO;
	INC	SI			;     zerosToTheLeft = 1
	MOV	DI, BX			;     zerosTotheRight = -(result.exp + 1)
	NOT	DI
	MOV	CX, AX			;     digitsToTheRight = result.len
	JMP	SHORT doneCounting	;     END;
					;   ELSE
expGE0:				; exp >= 0 - This takes care of result.len = 0
	CMP	AX, BX			;     DO
	JG	expLess			;     IF result.len <= result.exp THEN
	
	MOV	SI, BX			;       DO;
	SUB	SI, AX			;       zerosToTheLeft = result.exp - 
	INC	SI			;                        result.len + 1
	XOR	CX, CX			;       digitsToTheRight = 0
	JMP	SHORT doneCounting	;       END;

expLess:			; All significant digits are to the left
	MOV	CX, AX			;     ELSE
	SUB	CX, BX			;       digitsToTheRight = result.len -
	DEC	CX			;                          result.exp - 1
					;     END;
  
doneCounting:
	MOV	DX, AX			; digitsToTheLeft = result.len -
	SUB	DX, CX			;                   digitsTotheRight


	; Adjust the digits and zeros to the right of the decimal place for the 
	; proper # of decimal places
	; AX = decimalPlaces
	; BX = trailingZeros
	MOV	AX, param.decimalPlaces
	XOR	BX, BX			; trailingZeros = 0;

	CMP	AX, maxDecimalPlaces	; IF decimalPlaces < maxDecimalPlaces THEN
	JNB	doneAdjusting		;   DO;

	CMP	DI, AX			;   IF zerosToTheRight > decimalPlaces THEN
	JBE	zerosLess		;     DO;

	MOV	DI, AX			;     zerosToTheRight = decimalPlaces
	XOR	CX, CX			;     digitsToTheRight = 0
	JMP	SHORT adjust1		;     END;

zerosLess:				;   ELSE
	PUSH	DI			;     IF zerosTotheRight + digitsToTheRight >
	ADD	DI, CX			;        decimalPlaces THEN
	CMP	DI, AX
	POP	DI
	JLE	adjust1

	MOV	CX, AX			;       digitsTotheRight = decimalPlaces -
	SUB	CX, DI			;                          zerosToTheRight

adjust1:
	MOV	BX, AX			;   trailingZeros = decimalPlaces
	SUB	BX, DI			;                   - zerosToTheRight
	SUB	BX, CX			;                   - digitsToTheRight
					;   END;
doneAdjusting:
	; Save all of the counts
	MOV	local.trailingZeros, BX
	MOV	local.digitsTotheRight, CX
	MOV	local.digitsToTheLeft, DX
	MOV	local.zerosToTheLeft, SI
	MOV	local.zerosToTheRight, DI

	MOV	AX, param.negNum	; len = negNum +
	XOR	AH, AH
	CMP	param.decimalPlaces, scientific
	JNZ	roomForE		; IF scientific then leave room for an E
	INC	AX
roomForE:
	ADD	AX, BX			;       trailingZeros + 
	ADD	AX, CX			;       digitsToTheRight +
	ADD	AX, DX			;       digitstoTheLeft +
	ADD	AX, SI			;       zerostoTheLeft +
	ADD	AX, DI			;       zerosToTheRight +
	INC	AX			;       1

	LES	SI, param.ppStr
	LES	SI, DWORD PTR ES:[SI]	; Get the pointer to the string
	CMP	SI, 0FFFFH
	JNZ	checkMax
	MOV	BX, ES
	INC	BX			; IF (str = NIL) OR
	JZ	allocateStr
checkMax:
	CMP	AX, string.strMax	;    (str.max < len) THEN
	JB	stringIsOK

	; Allocate a new string
	PUSH	AX
	LES	AX, param.ppStr
	PUSH	ES
	PUSH	AX
	CALL FreeString
	POP	AX

allocateStr:
	PUSH	AX
	CALL NewString
	MOV	DX, ES			; Save the new stringPtr
	LES	SI, param.ppStr
	MOV	ES:[SI], BX
	MOV	ES:[SI+2], DX
	MOV	SI, BX
	MOV	ES, DX			; ES:SI points to the new string

stringIsOK:
	MOV	WORD PTR string.strLen, 0; str.len = 0

	; Initialize the string to zeros
	MOV	BX, 1			; BX will contain the string length
	LEA	DI, string.strChars[BX]	; CALL SetB ('0', @str.chars(1), str.max)
	MOV	AL, '0'
	MOV	CX, string.strMax
	CLD
	REP	STOSB			; ES:SI still points to the string
	DEC	BX

	MOV	AX, param.negNum
	RCR	AL, 1
	JNB	notNegative		; IF negNum THEN
					;   DO;
 	INC	BX			; str.len = str.len + 1
	MOV	BYTE PTR string.strChars[1], '-'; string.chars(1) = '-'
					;   END;
notNegative:
	; Move in the digits to the left
	MOV	CX, local.digitsToTheLeft
	JCXZ	noDigitsToTheLeft
   	PUSH	SI			; CALL MOVB(@result.chars(1),
	MOV	DI, param.resultPtr	;           @str.chars(str.len + 1), 
	MOV	DX, SS			;           digitsToTheLeft
	MOV	DS, DX
	LEA	DI, DS:[DI].chars[1]
	LEA	SI, ES:[SI+BX+1].strChars
	XCHG	SI, DI
	ADD	BX, CX			; See next line below
	CLD
	REP	MOVSB
	POP	SI			; ES:SI still points to the string

noDigitsToTheLeft:
	ADD	BX, local.zerosTotheLeft; str.len = str.len + digitsTotheLeft +
					;           zerosToTheLeft
					; IF zerosToTheRight + digitsToTheRight + 
	MOV	AX, local.zerosToTheRight  ; trailingZeros > 0 THEN
	ADD	AX, local.digitsToTheRight
	ADD	AX, local.trailingZeros
	JZ	checkScientific

	; Put in the digits and zeros to the right of the decimal place
	INC	BX			; str.len = str.len + 1
	MOV	BYTE PTR ES:[SI+BX].strChars, '.' ; str.chars(str.len) = '.'

	ADD	BX, local.zerosToTheRight; str.len = str.len + zerosToTheRight
	
	PUSH	SI
	MOV	DX, BX			; CALL MovB(@result.chars(digitsToTheLeft+1),
	MOV	DI, param.resultPtr	;           @str.chars(str.len + 1), 
	MOV	CX, SS
	MOV	DS, CX
	MOV	BX, local.digitsToTheLeft;          digitsToTheRight
	LEA	DI, DS:[DI+BX+1].chars
	MOV	BX, DX
	LEA	SI, ES:[SI+BX+1].strChars
	XCHG	SI, DI
	MOV	CX, local.digitsToTheRight
	ADD	BX, CX			; See next line below
	CLD
	REP	MOVSB
	POP	SI			; ES:SI still points to the string
	
	ADD	BX, local.trailingZeros	; str.len = str.len + digitsTotheRight +
					;           trailingZeros
	
checkScientific:
	; save the strings length
	MOV	string.strLen, BX

	CMP	param.decimalPlaces, scientific
	JNZ	notScientific		; IF (decimalPlaces = scientific) AND
	MOV	DI, param.resultPtr	;    (result.exp <> 0) AND
	CMP	result.len, 0		;    (result.len <> 0) AND
	JE	notScientific
	MOV	AX, result.resultExp	;    (IABS(result.exp) < maxDecimalPlaces)
	OR	AX, AX			;    THEN
	JZ	notScientific
	JNS	skip1
	NEG	AX
skip1:
	CMP	AX, maxDecimalPlaces
	JGE	notScientific

	INC	BX
	MOV	string.strLen, BX
	MOV	BYTE PTR ES:[SI+BX].strChars, 'E'

	LES	SI, param.ppStr
	LES	AX, DWORD PTR ES:[SI]	; Get the pointer to the string
	PUSH	ES	     		; str = ConcatStrings (@str,
	PUSH	AX			;           IntegerToString(result.exp))
	MOV	DI, param.resultPtr
	PUSH	result.resultExp
	CALL 	IntegerToString
	PUSH	ES
	PUSH	BX
	CALL 	ConcatStrings

	LDS	SI, param.ppStr
	MOV	DS:[SI], BX
	MOV	DS:[SI+2], ES

notScientific:
;---------------------
epilogue:
	MOV	SP,BP
	POP	BP
	RET	paramBytes

PutItIntoAString ENDP

PURGE localBytes, locals, local, paramBytes, params, param, oldBP, returnIP, epilogue, result, decimalPlaces, ppStr, pNum, string, negNum, continue

$EJECT 
PUBLIC numIsOk, noCarry, continue, noIntegerpart
;------------------------------------------------------------
RealToBuffer PROC NEAR
;PROCEDURE RealToBuffer (VAR num: LongReal; VAR str: StringPtr;
;                            decimalPlaces: Word);
; 
; This routine converts the specified long real number into a string.  If the 
; provided string is large enough, it is used.  Otherwise a new string is allocated.
;------------------------------------------------------------

localBytes	EQU resultTypeLen + 10
local		EQU [BP-localBytes]
locals STRUC
;---------------------
resultLen	DW ?			; Len
resultExponent	DW ?			; Exp
resultChars	DB resultMax DUP (?)	; Chars
negNum		DW ?
base		DB 8 DUP(?)
;---------------------
locals ENDS

paramBytes	EQU 10
param		EQU [BP]
params STRUC
;---------------------
oldBP		DW ?
returnIP	DW ?
;---------------------
decimalPlaces	DW ?
ppStr		DD ?
pNum		DD ?
;---------------------
params ENDS

num		EQU ES:[SI]

;Prologue
	PUSH	BP
	MOV	BP,SP
	SUB	SP,localBytes
	PUSH	DS			; DS will be used as a general register below
;---------------------
	XOR	AX, AX
	MOV	local.resultLen, AX
	MOV	local.resultExponent, AX

	LES	SI, param.pNum		; negNum = SHR(num(7), 7)
	MOV	BL, num[7]
	SHL	BL, 1
	RCL	AX, 1
	MOV	local.negNum, AX

	MOV	AX, num[6]		; exp = SHR(num(6), 4) AND 07FFH
	MOV	CL, 4
	SHR	AX, CL
	MOV	CX, 07FFH
	AND	AX, CX

	CMP	AX, CX			; IF exp = expallOnes THEN
	JNZ	numIsOK

	LES	AX, param.ppStr		; CALL FreeString (str)
	PUSH	ES
	PUSH	AX
	CALL	FreeString

	MOV	AX, OFFSET errorConst	; pStr = NewStringLit ('Error')
	PUSH	CS
	PUSH	AX
	CALL	NewStringLit
	MOV	DX, ES
	LES	SI, param.ppStr
	MOV	ES:[SI], BX
	MOV	ES:[SI+2], DX

	JMP	epilogue		; RETURN

numIsOK:
	; Long reals have 53 bits of precision - copy them into a working variable
	MOV	BX, ES			; ES:SI points to the num
	MOV	DS, BX
	LEA	DI, local.base		; CALL MovB(pNum, @base, 7)
	MOV	BX, SS
	MOV	ES, BX
	MOV	CX, 7
	CLD
	REP	MOVSB

	MOV	local.base[7], 0	; base(7) = 0

	; Set the implied integer bit and round if the number is not a 
	; denormal (or a 0)
	OR	AX, AX			; IF exp <> 0 THEN
	JZ	continue

	MOV	BL, local.base[6]	; base(6) = (base(6) AND 0FH) OR 010H
	AND	BL, 00FH
	OR	BL, 010H
	MOV	local.base[6], BL

	; Round it at the lowest bit
	ADD	WORD PTR local.base[0], 1
	ADC	WORD PTR local.base[2], 0
	ADC	WORD PTR local.base[4], 0
	ADC	WORD PTR local.base[6], 0

	; Check to see if it was all 1's before (and if there was a carry)
	TEST	BYTE PTR local.base[6], 20H ; IF base(6) bit 5 = 1 THEN
	JZ	noCarry

	; It must have been all ones, adjust the num and exponent
	MOV	BYTE PTR local.base[6], 10H ; base(6) = 10H
	INC	AX			; exp = exp + 1

noCarry:
	SUB	AX, 1023		; Unbias the exponent

continue:
					; IF exp >= 0 THEN
	PUSH	AX			; push as a parm for convertFractionPart
	JL	noIntegerPart

	PUSH	AX			;   CALL ConvertIntegerPart(exp, @base,
	LEA	AX, local.base		;                           @result)
	PUSH	AX
	LEA	AX, local.resultLen
	PUSH	AX
	CALL	ConvertIntegerPart

noIntegerPart:
	LEA	AX, local.base	   	; CALL ConvertFractionPart(exp, @base, 
	PUSH	AX			;			   @result, 
	LEA	AX, local.resultLen	;			   decimalPlaces)
	PUSH	AX
	PUSH	param.decimalPlaces
	CALL	ConvertFractionPart

	LEA	DI, local.resultLen	; CALL RoundResult (@result)
	CALL	RoundResult

	LES	AX, param.ppStr		; CALL PutItIntoAString (ppStr, @result
	PUSH	ES			;                        decimalPlaces,
	PUSH	AX			;                        negNum)
	LEA	AX, local.resultLen
	PUSH	AX
	PUSH	param.decimalPlaces
	PUSH	local.negNum
	CALL	PutItIntoAString
;---------------------
epilogue:
	POP	DS
	MOV	SP,BP
	POP	BP
	RET	paramBytes

RealToBuffer ENDP

PURGE localBytes, locals, local, paramBytes, params, param, oldBP, returnIP, epilogue

$EJECT 
;------------------------------------------------------------
RealToString PROC NEAR
;FUNCTION RealToString (num: LongReal; fracDigits: Integer): StringPtr;
; 
; This routine converts the specified long real number into a string.  A string is
; allocated to contain the number.
;
; Register usage
;	Parameters	Top of 8087 stack = number to convert
;       Destroyed	All
;	Returned	ES:BX = StringPtr
;------------------------------------------------------------

localBytes	EQU 12
local		EQU [BP-localBytes]
locals STRUC
;---------------------
aReal		DQ ?
str		DD ?
;---------------------
locals ENDS

paramBytes	EQU 2
param		EQU [BP]
params STRUC
;---------------------
oldBP		DW ?
returnIP	DW ?
;---------------------
fracDigits	DW ?
;---------------------
params ENDS

;Prologue
	PUSH	BP
	MOV	BP,SP
	SUB	SP,localBytes
;---------------------
	FSTP	local.aReal		; Pop the number into a local so that it
	FWAIT				; can be passed VAR

   	; str = NIL
	MOV	WORD PTR local.str, 0FFFFH
	MOV	WORD PTR local.str[2], 0FFFFH

	LEA	AX, local.aReal
	PUSH	SS
	PUSH	AX
	LEA	AX, local.str
	PUSH	SS
	PUSH	AX
	PUSH	param.fracDigits
	CALL	RealToBuffer

	LES	BX, local.str		; Return the stringPtr

;---------------------
epilogue:
	MOV	SP,BP
	POP	BP
	RET	paramBytes

RealToString ENDP

PURGE localBytes, locals, local, paramBytes, params, param, oldBP, returnIP, epilogue

CODE  ENDS

END
